#
# Function to plot multiple ggplots alongside each other
#
# Takes a list of plot objects as input
#   optionally the number of rows over which the plots are to be printed can be added, this cannot be more than the number of plots
#
# Written by: BW Berkhout
# version 0.2.3: 25 Jan 2017
#
###################################################################################################################################

ggmultiplot = function(plots, Nrow = 1){
  if(!require(grid)) install.packages("grid")
  if(!require(useful)) install.packages("useful")
  library(grid)
  library(useful)
  
  nplots = length(plots)
  
  if(Nrow > nplots) {
    print("Number of rows exceeds number of plots")
    break
  }
  
  if(Nrow == 1) {
    Ncol = nplots
    rowlist = as.list(rep(1:Nrow, each = Ncol))
    collist = as.list(rep(1:Ncol, each = Nrow))
  }
  
  else {
    Ncol = ceiling(nplots / Nrow)
    rowlist = as.list(rep(1:Nrow, each = Ncol))
    collist = as.list(rep(1:Ncol, each = Nrow))
    if(nplots %% Nrow != 0) {
      Ncol = Ncol * 2
      xx = rep(1:Ncol, times = Nrow)
      collist = list(NULL)
      for(i in 1:nplots) {
        collist[[i]] = (c(xx[i * 2 - 1], xx[i * 2]))
      }
      xx = (nplots %% (Ncol / 2))
      for(i in nplots:(nplots - (xx - 1))) {
        collist[[i]] = collist[[i]] + 1
      }
    }
  }
  
  grid.newpage()
  pushViewport(viewport(layout = grid.layout(Nrow, Ncol)))
  
  for(i in 1:nplots) {
    print(plots[[i]], vp = vplayout(c(rowlist[[i]]), as.vector(collist[[i]])))
  }
}